## .vert

uniform float foo;
uniform float mix;
uniform float zoom;

const float wc = 1.0 / 1280.0;
const float hc = 1.0 / 640.0;

void main()
	{
	vec4 v = gl_Vertex;

	v.x = ( v.x - 640.0 ) * ( 1.0 + sin( v.y * 0.01 + foo ) ) + 640.0;
	v.y = ( v.y - 320.0 ) * ( 1.0 + sin( v.x * 0.011 + foo * 1.1 ) ) + 320.0;
	v.x += ( v.x - 640.0 ) * ( 1.0 + sin( v.y * 0.012 + foo * 1.2 ) ) * 0.25;
	v.y += ( v.y - 320.0 ) * ( 1.0 + cos( v.x * 0.013 + foo * 1.3 ) ) * 0.25;
	v.x += ( v.x - 640.0 ) * ( 1.0 + cos( v.y * 0.014 + foo * 1.4 ) ) * 0.25;
	v.y += ( v.y - 320.0 ) * ( 1.0 + sin( v.x * 0.015 * foo * 1.5 ) ) * 0.25;
	
	v.x += ( v.x - 640.0 ) * zoom;
	v.y += ( v.y - 320.0 ) * zoom;
	
	vec4 v2 = v * mix + gl_Vertex * ( 1.0 - mix );

	gl_Position = gl_ModelViewProjectionMatrix * v2;
	
	vec4 t = gl_MultiTexCoord0;
	t.x *= sin( foo );
	t.y *= cos( foo * 0.9 );
	gl_TexCoord[0] = t;
	}

## .frag

uniform sampler2D tex;

void main()
	{
	vec4 color = texture2D( tex, gl_TexCoord[0].st );
	gl_FragColor = color;
	}